// Wiggle Up v1.0.2
// Bugfixes:
// - Round frequency and amplitude sliders before passing to wiggle()
// - Use real newlines in the expression string (previous build used escaped \n)
// Author: Florian Feldmann
// Date: 2025-10-13

(function wiggleUpPanel(thisObj) {
    var VERSION = "v1.0.2";

    function buildUI(thisObj) {
        var myPanel = (thisObj instanceof Panel) ? thisObj : new Window("palette", "Wiggle Up " + VERSION, undefined, {resizeable:true});
        myPanel.orientation = "column";
        myPanel.alignChildren = ["fill", "top"];
        var btn = myPanel.add("button", undefined, "Go!");

        btn.onClick = function () {
            app.beginUndoGroup("Wiggle Up " + VERSION);

            var comp = app.project.activeItem;
            if (!(comp && comp instanceof CompItem)) {
                alert("Please select a comp and a layer property.");
                app.endUndoGroup();
                return;
            }

            var layer = comp.selectedLayers[0];
            if (!layer) {
                alert("Please select a layer.");
                app.endUndoGroup();
                return;
            }

            var prop = layer.selectedProperties[0];
            if (!(prop && prop.canSetExpression)) {
                alert("Please select a property that can have an expression.");
                app.endUndoGroup();
                return;
            }

            var val = prop.value;
            var dim = val instanceof Array ? val.length : 1;

            var effects = layer.property("ADBE Effect Parade");
            if (!effects) {
                alert("Could not access Effects on the selected layer.");
                app.endUndoGroup();
                return;
            }

            function addSlider(name, val) {
                var ctrl = effects.addProperty("ADBE Slider Control");
                ctrl.name = name;
                ctrl.property("ADBE Slider Control-0001").setValue(val);
                return ctrl.name;
            }

            function addCheckbox(name, defaultValue) {
                var ctrl = effects.addProperty("ADBE Checkbox Control");
                ctrl.name = name;
                if (typeof defaultValue === "number") {
                    ctrl.property("ADBE Checkbox Control-0001").setValue(defaultValue);
                }
                return ctrl.name;
            }

            // Controls
            var freqName = addSlider("Wiggle Frequency", 2);
            var ampNames = [];
            if (dim === 1) {
                ampNames.push(addSlider("Wiggle Amplitude", 30));
            } else if (dim === 2) {
                ampNames.push(addSlider("Wiggle Amplitude X", 30));
                ampNames.push(addSlider("Wiggle Amplitude Y", 30));
            } else if (dim === 3) {
                ampNames.push(addSlider("Wiggle Amplitude X", 30));
                ampNames.push(addSlider("Wiggle Amplitude Y", 30));
                ampNames.push(addSlider("Wiggle Amplitude Z", 30));
            }

            var separateDim = (dim > 1) ? addCheckbox("Separate Dimensions", 0) : null;

            // Build expression with real newlines
            var nl = "\n"; // we'll replace to real newlines at the end for readability during assembly
            var ex = "";
            ex += "t = time;" + nl;
            ex += "freq = Math.round(effect(\"" + freqName + "\")(\"Slider\"));" + nl;

            if (dim === 1) {
                ex += "amp = Math.round(effect(\"" + ampNames[0] + "\")(\"Slider\"));" + nl;
                ex += "wiggle(freq, amp)";
            } else {
                ex += "sep = effect(\"" + separateDim + "\")(\"Checkbox\") == 1;" + nl;
                ex += "ampX = Math.round(effect(\"" + ampNames[0] + "\")(\"Slider\"));" + nl;
                ex += "ampY = Math.round(effect(\"" + ampNames[1] + "\")(\"Slider\"));" + nl;
                if (dim === 3) ex += "ampZ = Math.round(effect(\"" + ampNames[2] + "\")(\"Slider\"));" + nl;

                ex += "if (!sep) {" + nl;
                ex += "  v = wiggle(freq, ampX);" + nl;
                if (dim === 2) {
                    ex += "  v.length === 2 ? v : [v[0], v[1]];" + nl;
                } else {
                    ex += "  v.length === 3 ? v : [v[0], v[1], 0];" + nl;
                }
                ex += "} else {" + nl;
                ex += "  [" + nl;
                ex += "    wiggle(freq, ampX)[0]," + nl;
                ex += "    wiggle(freq, ampY)[1]";
                if (dim === 3) {
                    ex += "," + nl + "    wiggle(freq, ampZ).length > 2 ? wiggle(freq, ampZ)[2] : 0";
                }
                ex += nl + "  ];" + nl;
                ex += "}";
            }

            // Convert placeholders to real newlines
            var expr = ex.split("\n").join("\r\n");

            try {
                prop.expression = expr;
            } catch (e) {
                alert("Failed to set expression: " + e.toString());
                app.endUndoGroup();
                return;
            }

            app.endUndoGroup();
        };

        myPanel.layout.layout(true);
        return myPanel;
    }

    var win = buildUI(thisObj);
    if (win instanceof Window) {
        win.center();
        win.show();
    }
})(this);
